//=============================================================================
// Plugin for RPG Maker MZ
// HideStatusOnBattle.js (Center toggle version)
//=============================================================================
// [Update History]
// 2022.May.14 Ver1.0.0 First Release
// 2025.Add CenterCommand parameter

/*:
 * @target MZ
 * @plugindesc Hide Status And (Optionally) Move Commands To Center
 * @author Sasuke KANNAZUKI / modified
 *
 * @param CenterCommand
 * @text コマンド中央寄せ
 * @type boolean
 * @default true
 * @desc true の場合、アクターコマンド・パーティコマンドを中央に寄せて表示します。
 *
 * @help This plugin does not provide plugin commands.
 * - Hide Status Window
 * - Optionally move command windows to center
 *
 * This plugin assumes the use of special battle sequence.
 *
 * Released under MIT license.
 */

/*:ja
 * @target MZ
 * @plugindesc バトル時、ステータスを非表示にし、コマンドを中央に移動する（任意）
 * @author 神無月サスケ / 改変：ユースフル小屋
 *
 * @param CenterCommand
 * @text コマンド中央寄せ
 * @type boolean
 * @default true
 * @desc true の場合、アクターコマンド・パーティコマンドを中央に表示します。false の場合は移動しません。
 *
 * @help このプラグインにはプラグインコマンドはありません。
 * - ステータスウィンドウを非表示にします。
 * - コマンドを中央にするかどうかはパラメータで切り替えできます。
 *
 * MITライセンスで配布されています。
 */

(() => {
  const parameters = PluginManager.parameters("HideStatusOnBattle");
  const centerCommand = parameters["CenterCommand"] === "true";

  //
  // Hide status window during battle
  //
  Scene_Battle.prototype.createStatusWindow = function() {
    const rect = this.statusWindowRect();
    const statusWindow = new Window_BattleStatus(rect);
    // this.addWindow(statusWindow);   //非表示にするため追加しない
    this._statusWindow = statusWindow;
  };

  const _Scene_Battle_terminate = Scene_Battle.prototype.terminate;
  Scene_Battle.prototype.terminate = function() {
    // Dispose のために終了時のみ追加
    this.addWindow(this._statusWindow);
    _Scene_Battle_terminate.call(this);
  };

  //
  // Move actor command window to center (optional)
  //
  const _Scene_Battle_actorCommandWindowRect =
    Scene_Battle.prototype.actorCommandWindowRect;
  Scene_Battle.prototype.actorCommandWindowRect = function() {
    const rect = _Scene_Battle_actorCommandWindowRect.call(this);
    if (centerCommand) {
      rect.x = (Graphics.boxWidth - rect.width) / 2;
    }
    return rect;
  };

  //
  // Move party command window to center (optional)
  //
  const _Scene_Battle_partyCommandWindowRect =
    Scene_Battle.prototype.partyCommandWindowRect;
  Scene_Battle.prototype.partyCommandWindowRect = function() {
    const rect = _Scene_Battle_partyCommandWindowRect.call(this);
    if (centerCommand) {
      rect.x = (Graphics.boxWidth - rect.width) / 2;
    }
    return rect;
  };

})();
